<?php $__env->startSection('title', 'Content Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Content Management</h1>
    <a href="<?php echo e(route('admin.contents.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New Content
    </a>
</div>

<?php if($sections->count() > 0): ?>
<div class="mb-4">
    <div class="btn-group" role="group">
        <a href="<?php echo e(route('admin.contents.index')); ?>" class="btn btn-outline-secondary <?php echo e(!request('section') ? 'active' : ''); ?>">All</a>
        <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('admin.contents.index', ['section' => $section])); ?>" class="btn btn-outline-secondary <?php echo e(request('section') == $section ? 'active' : ''); ?>"><?php echo e(ucfirst($section)); ?></a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <?php if($contents->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Page Key</th>
                        <th>Section</th>
                        <th>Label</th>
                        <th>Type</th>
                        <th>Content Preview</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><code><?php echo e($content->page_key); ?></code></td>
                        <td><?php echo e($content->section ?? 'N/A'); ?></td>
                        <td><?php echo e($content->label); ?></td>
                        <td><span class="badge bg-info"><?php echo e($content->type); ?></span></td>
                        <td><?php echo e(Str::limit($content->content, 50)); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.contents.show', $content)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.contents.edit', $content)); ?>" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="<?php echo e(route('admin.contents.destroy', $content)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this content?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <p class="text-muted mb-0">No content entries yet. <a href="<?php echo e(route('admin.contents.create')); ?>">Create your first content entry</a>.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/admin/contents/index.blade.php ENDPATH**/ ?>